// ContentsEsc_l.cpp : CContentsEsc_l Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_l, CObject, 1)



// Serialize draw data
void CContentsEsc_l::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_l::Draw(CDC* pDC)
{
	int iAngle ;

	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);

	int OldBkMode = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));


	pDC->MoveTo(m_Data.iX1,m_Data.iY1);
	pDC->LineTo(m_Data.iX2,m_Data.iY2);
	
	if( m_Data.iArrowPattern ){
		if( GetLineAngle(m_Data.iX2,m_Data.iY2,m_Data.iX1,m_Data.iY1,&iAngle)){

			if( m_Data.iArrowDirection != 2 ){
				// I_̖̕
				AngleLine(pDC,m_Data.iX2,m_Data.iY2, 8 ,iAngle+145) ;
				AngleLine(pDC,m_Data.iX2,m_Data.iY2, 8 ,iAngle-145) ;
			}
			if( m_Data.iArrowDirection != 1 ){
				// Jn_̖̕
				AngleLine(pDC,m_Data.iX1,m_Data.iY1, 8 ,iAngle+145+180) ;
				AngleLine(pDC,m_Data.iX1,m_Data.iY1, 8 ,iAngle-145+180) ;
			}
		}
	}


	pDC->SetBkMode( OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);

}

// Transmit the data to GP
int CContentsEsc_l::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_l(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iArrowPattern,m_Data.iArrowDirection,m_Data.iX1,m_Data.iY1,m_Data.iX2,m_Data.iY2)) ;
}
